#ifndef FILEPLAYERDLG_H
#define FILEPLAYERDLG_H

#include <QWidget>
#include <QtGui>
#include <QtCore>

namespace Ui {
class FilePlayerDlg;
}

class FilePlayerDlg : public QWidget
{
    Q_OBJECT

public:
    explicit FilePlayerDlg(QWidget *parent = 0);
    ~FilePlayerDlg();

private slots:
    void on_pushButton_OPEN_clicked();

    void on_pushButton_PLAY_clicked();

    void on_pushButton_PAUSE_clicked();

    void on_pushButton_STOP_clicked();

    void on_pushButton_SPEED_PLUS_clicked();

    void on_pushButton_SPEED_MINUS_clicked();

    void on_pushButton_SANPSHOT_clicked();

    void on_pushButton_ANALYSIS_clicked();

private:
    Ui::FilePlayerDlg *ui;

public:
    PVOID		m_pFile;

    ULONG		m_nVideoFormat;

    ULONG		m_nVideoWidth;

    ULONG		m_nVideoHeight;

    double		m_dVideoFrameRate;

    ULONG		m_nAudioFormat;

    ULONG		m_nAudioChannels;

    ULONG		m_nAudioBitsPerSample;

    ULONG		m_nAudioSampleFrequency;

    double		m_dFileTotalDuationTimes;

    ULONG		m_nFileTotalVideoFrames;

    ULONG		m_nFileTotalAudioFrames;

	ULONG		m_nFileTotalMetadataFrames;

    double      speed;

    QString     FilePath;

    QByteArray  FilePath_ByteArray;

    QString     psz_info;

    CHAR*       psz;

    CHAR*       vfmt;

    CHAR*       afmt;

    void        timerEvent( QTimerEvent *event );

    int         m_nTimerId_1;

    int         m_nTimerId_2;

    double      g_d_audio_volume_db_left;

    double      g_d_audio_volume_db_right;
};

#endif // FILEPLAYERDLG_H
